unit mainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtDlgs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ToolWin, ImgList, Menus,
  About;

type
  TForm1 = class(TForm)
    SavePictureDialog1: TSavePictureDialog;
    OpenPictureDialog1: TOpenPictureDialog;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    ToolBar1: TToolBar;
    OpenBtn: TToolButton;
    SaveBtn: TToolButton;
    ImageList1: TImageList;
    Panel2: TPanel;
    ProgressBar1: TProgressBar;
    updnQuality: TUpDown;
    ToolButton1: TToolButton;
    cboxProgressive: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    ToolButton2: TToolButton;
    stxtQuality: TStaticText;
    MainMenu1: TMainMenu;
    Files: TMenuItem;
    About1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    ToolButton3: TToolButton;

    procedure SaveGraphicsFile (RqLoadCode,
                                RqSaveCode : integer;
                                RqFileName : string);
    procedure Image1Progress(Sender: TObject; Stage: TProgressStage;
      PercentDone: Byte; RedrawNow: Boolean; const R: TRect;
      const Msg: String);

    procedure FormCreate(Sender: TObject);
    procedure OpenBitBtnClick(Sender: TObject);
    procedure SaveBitBtnClick(Sender: TObject);
    procedure updnQualityChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
//      JPEG
uses jpeg;

var GraphLoadCode  : Integer;            //   
    Quality        : TJpegQualityRange;  //    JPEG

// ------------------------------------------------------------------
// 
procedure TForm1.FormCreate(Sender: TObject);
begin
 GraphLoadCode := 0;   //     
 //      
 OpenPictureDialog1.Filter := GraphicFilter(TGraphic)
                            + '|'
                            + GraphicFilter(TJpegImage);
 //     JPEG
 Quality := 75;
 updnQuality.Position := Quality;
end;

// ------------------------------------------------------------------
//   
procedure TForm1.OpenBitBtnClick(Sender: TObject);
begin
 GraphLoadCode := 0;  //   
 if OpenPictureDialog1.Execute
 then begin

    //      
    Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);

    //      JPEG
    if Image1.Picture.Graphic is TJpegImage then
    begin
      GraphLoadCode := 1;   //  JPEG 
      //     
      SavePictureDialog1.Filter := GraphicFilter(TBitmap)
                                 + '|'
                                 + 'JPG Image files (*.jpg *.jpeg)|*.jpg;*.jpeg';
    end;

    //      BitMap
    if Image1.Picture.Graphic is TBitmap then
    begin
      GraphLoadCode := 2;   //  BitMap 
      //    JPEG
      Image1.Picture.Bitmap.PixelFormat := pf24bit;
      //     
      SavePictureDialog1.Filter := GraphicFilter(TBitmap)
                                 + '|'
                                 + 'JPG Image files (*.jpg *.jpeg)|*.jpg;*.jpeg';
    end;

    //      Icon
    if Image1.Picture.Graphic is TIcon then
    begin
      GraphLoadCode := 3;   //  Icon 
      //     
      SavePictureDialog1.Filter := GraphicFilter(TIcon);
    end;

    //      Metafile
    if Image1.Picture.Graphic is TMetafile then
    begin
      GraphLoadCode := 4;   //  Metafile 
      //     
      SavePictureDialog1.Filter := GraphicFilter(TMetafile);
    end;
    //     
    if GraphLoadCode > 0
    then begin
      SaveBtn.Visible := True;
      Save1.Enabled  := True;
    end;
  end;
end;

// ------------------------------------------------------------------
//   JPEG - 
procedure TForm1.updnQualityChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
    Quality := updnQuality.Position;
    stxtQuality.Caption := IntToStr(updnQuality.Position);
end;

// ------------------------------------------------------------------
//    JPEG  - 
procedure TForm1.Image1Progress(Sender: TObject; Stage: TProgressStage;
  PercentDone: Byte; RedrawNow: Boolean; const R: TRect;
  const Msg: String);
begin
   case Stage of
   psStarting: begin
                Progressbar1.Position := 0;
                Progressbar1.Max := 100;
               end;
   psEnding  : begin
                Progressbar1.Position := 0;
               end;
   psRunning : begin
                 Progressbar1.Position := PercentDone;
               end;
   end;
end;

// ------------------------------------------------------------------
//   
procedure TForm1.SaveGraphicsFile (RqLoadCode,
                                   RqSaveCode : integer;
                                   RqFileName : string);
var SaveErr : boolean;
    jp      : TJpegImage;
    bm      : TBitmap;
begin
   SaveErr := False;
   case RqLoadCode of
     1: begin //   .jpg
          case RqSaveCode of
          1 : begin //   jpg  .bmp
                bm := nil;
                try
                  //   
                  bm := TBitmap.Create;
                  bm.PixelFormat := pf24bit;
                  bm.Assign(Image1.Picture.Graphic);
                  bm.SaveToFile(RqFileName);
                except SaveErr := True;
                end;
                //  
                if bm <> nil then bm.Free;
              end;
          2 : begin    //   jpg  .jpg
                try    Image1.Picture.Graphic.SaveToFile(RqFileName);
                except SaveErr := True;
                end;
              end;
          end; // of case RqSaveCode
        end;
     2: begin  //   .bmp
          case RqSaveCode of
          1 : begin    //   bmp  .bmp
                try    Image1.Picture.Bitmap.SaveToFile(RqFileName);
                except SaveErr := True;
                end;
              end;
          2 : begin //   bmp  .jpg
                jp := nil;
                try  //   
                  jp := TJpegImage.Create;
                  //   BitMap
                  jp.PixelFormat := jf24bit;
                  jp.CompressionQuality := Quality;
                  jp.ProgressiveEncoding := cboxProgressive.Checked;
                  //   
                  jp.OnProgress := Image1Progress;
                  jp.Assign(Image1.Picture.Bitmap);
                  jp.SaveToFile(RqFileName);
                except SaveErr := True;
                end;
                //  
                if jp <> nil then jp.Free;
              end;
          end; // of case RqSaveCode
        end;
     3: begin     //   .ico
           try    Image1.Picture.Icon.SaveToFile(RqFileName);
           except SaveErr := True;
           end;
        end;
     4: begin     //   .wmf
           try    Image1.Picture.Metafile.SaveToFile(RqFileName);
           except SaveErr := True;
           end;
        end;
   end; // case
   if SaveErr then ShowMessage ('   : '
                               + RqFileName);
end;

// ------------------------------------------------------------------
//   
procedure TForm1.SaveBitBtnClick(Sender: TObject);
var ExtName : string;
begin
with SavePictureDialog1 do
begin
   //       
   FilterIndex := 1;
   //   ,     
   FileName := '';
   ExtName  := '';
   //  
   if not Execute then Exit;

   //    
   ExtName := ExtractFileExt(FileName);
   if ExtName = '' then
   begin
     //     
     case GraphLoadCode of
     1,2: begin
            if (FilterIndex = 1)
            then ExtName := '.bmp'
            else ExtName := '.jpg';
          end;
       3: ExtName := '.ico';
       4: ExtName := '.wmf';
     end;
     FileName := FileName + ExtName;
   end
   else begin
   //      
     case GraphLoadCode of
     1,2: begin
            if not ((UpperCase(ExtName) = '.BMP') or
                    (UpperCase(ExtName) = '.JPG'))
            then Exit;
          end;
       3: if not (UpperCase(ExtName) = '.ICO') then Exit;
       4: if not (UpperCase(ExtName) = '.WMF') then Exit;
     end;
   end;
   //  
   SaveGraphicsFile (GraphLoadCode, FilterIndex, FileName);
end; // with

end;

// ------------------------------------------------------------------
//  
procedure TForm1.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

// ------------------------------------------------------------------
//  
procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
